#include <memory>

#include <rclcpp/rclcpp.hpp>
#include "hik_camera/hik_camera.hpp"
#include "common/mavlink.h"


int main(int argc, char * argv[])
{
  rclcpp::init(argc, argv);
  rclcpp::executors::SingleThreadedExecutor exec;
  rclcpp::NodeOptions options;

  SyncClient client("127.0.0.1", BASE_PORT);
  client.receiveThreadStart();

  auto hikcamera_node = std::make_shared<camera::CameraNode>(&client, "hik_camera", options);

  exec.add_node(hikcamera_node);

  exec.spin();
  rclcpp::shutdown();
  return 0;
}

