#include "sync_board.hpp"
#include <iostream>
#include <ctype.h>

int main(int argc, char **argv)
{
    if(argc < 2)
    {
        std::cerr << "Usage: " << argv[0] << " + control commands + FPS(default: 0)" << std::endl;
        std::cerr << "  1 - single trigger" << std::endl;
        std::cerr << "  2 - set frame rate" << std::endl;
        std::cerr << "     e.g. " << argv[0] << " 2 10  --> set 10 FPS" << std::endl;
        return -1;
    }
    SyncBoard board;
    if(!board.connect("/dev/ttyACM0", 921600))
    {
        std::cerr << "Failed to connect to SyncBoard." << std::endl;
        return -1;
    }
    board.start_recv_message();
    
    int command = atoi(argv[1]);
    switch(command)
    {
        case 1: 
            {
                board.CamOneShotTrigger(); 
                std::cout << "Camera one-shot trigger sent." << std::endl;
            }
            break;
        case 2:
            {
                int fps = 0;
                if(argc >=3){
                    fps = atoi(argv[2]);
                }
                board.SetCamFrame(fps);
                std::cout << "Set camera frame rate to " << fps << " FPS." << std::endl;
            }
            break;
        default:
            std::cerr << "Unknown command." << std::endl;
            std::cerr << "Usage: " << argv[0] << " + control commands + FPS(default: 0)" << std::endl;
            std::cerr << "  1 - single trigger" << std::endl;
            std::cerr << "  2 - set frame rate" << std::endl;
            std::cerr << "     e.g. " << argv[0] << " 2 10  --> set 10 FPS" << std::endl;
            return -1;
    }

    return 0;
}
