#include "sync_board.hpp"
#include <iostream>
#include <thread>

int main() {
    SyncBoard board;

    // windows下请修改为相应的串口名称，例如"COM3"
    if (!board.connect("/dev/ttyACM0", 921600)) {
        std::cerr << "Failed to connect" << std::endl;
        return -1;
    }

    board.start_recv_message();

    // 打开消息接收后会收到同步板的同步请求，此时时间戳赋值已经完成
    // 这里等待是等待收敛，完成更高精度的时间同步，具体原理可参考https://mavlink.io/en/services/timesync.html
    // 并不影响相机的同步触发精度
    std::cout << "Waiting for timesync..." << std::endl;
    while (!board.isTimesyncOk()) {
        std::this_thread::sleep_for(std::chrono::milliseconds(100));
    }

    std::cout << "Timesync successful!" << std::endl;

    board.stop_recv_message();
    board.disconnect();
    return 0;
}
