#include "sync_board.hpp"
#include <iostream>

int main(int argc, char **argv)
{
    if (argc < 2)
    {
        std::cerr << "Usage: " << argv[0] << " <upgrade_file_path> " << std::endl;
        return -1;
    }

    SyncBoard board;
    if (!board.connect("/dev/ttyACM0", 921600)) {
        std::cerr << "Failed to connect" << std::endl;
        return -1;
    }

    std::string upgrade_file_path = argv[1];

    board.upgradeFirmware(upgrade_file_path);
    return 0;
}
