#include "sync_board.hpp"
#include <iostream>

int main(int argc, char **argv)
{
    if(argc < 2)
    {
        std::cerr << "Usage: " << argv[0] << " + time source " << std::endl;
        std::cerr << "  0 - board boot time" << std::endl;
        std::cerr << "  1 - network time" << std::endl;
        std::cerr << "  2 - GPS time" << std::endl;
        return -1;
    }

    SyncBoard board;
    if(!board.connect("/dev/ttyACM0", 921600))
    {
        std::cerr << "Failed to connect to SyncBoard." << std::endl;
        return -1;
    }
    board.start_recv_message();
    
    int command = atoi(argv[1]);
    switch(command)
    {
        case 0: 
            {
                board.SetTimeSource(0); 
                std::cout << "Set time source to board boot time." << std::endl;
            }
            break;
        case 1:
            {
                board.SetTimeSource(1);
                std::cout << "Set time source to network time." << std::endl;
            }
            break;
        case 2:
            {
                board.SetTimeSource(2);
                std::cout << "Set time source to GPS time." << std::endl;
            }
            break;
        default:
            std::cerr << "Unknown command." << std::endl;
            std::cerr << "Usage: " << argv[0] << " + time source " << std::endl;
            std::cerr << "  0 - board boot time" << std::endl;
            std::cerr << "  1 - network time" << std::endl;
            std::cerr << "  2 - GPS time" << std::endl;
            return -1;
    }

    return 0;
}
